#include <core/ports.h>

Port::Port(uint16_t portNumber) {
    this->portNumber = portNumber;
}

Port::~Port() {
}

// Port8Bit
Port8Bit::Port8Bit(uint16_t portNumber) : Port(portNumber) {}

Port8Bit::~Port8Bit() {}

void Port8Bit::Write(uint8_t data) {
    asm volatile ("outb %0, %1" : : "a"(data), "Nd"(portNumber));
}

uint8_t Port8Bit::Read() {
    uint8_t result;
    asm volatile ("inb %1, %0" : "=a"(result) : "Nd"(portNumber));
    return result;
}

// Port8BitSlow
Port8BitSlow::Port8BitSlow(uint16_t portNumber) : Port8Bit(portNumber) {}

Port8BitSlow::~Port8BitSlow() {}

void Port8BitSlow::Write(uint8_t data) {
    asm volatile ("outb %0, %1\n\tjmp 1f\n1:\tjmp 1f\n1:" : : "a"(data), "Nd"(portNumber));
}


// Port16Bit
Port16Bit::Port16Bit(uint16_t portNumber) : Port(portNumber) {}

Port16Bit::~Port16Bit() {}


void Port16Bit::Write(uint16_t data) {
    asm volatile ("outw %0, %1" : : "a"(data), "Nd"(portNumber));
}

uint16_t Port16Bit::Read() {
    uint16_t result;
    asm volatile ("inw %1, %0" : "=a"(result) : "Nd"(portNumber));
    return result;
}


// Port32Bit
Port32Bit::Port32Bit(uint16_t portNumber) : Port(portNumber) {}

Port32Bit::~Port32Bit() {}

void Port32Bit::Write(uint32_t data) {
    asm volatile ("outl %0, %1" : : "a"(data), "Nd"(portNumber));
}

uint32_t Port32Bit::Read() {
    uint32_t result;
    asm volatile ("inl %1, %0" : "=a"(result) : "Nd"(portNumber));
    return result;
}